import nncam
import time

class App:
    def __init__(self):
        self.hcam = None
        self.buf = None
        self.total = 0

# the vast majority of callbacks come from nncam.dll/so/dylib internal threads
    @staticmethod
    def cameraCallback(nEvent, ctx):
        if nEvent == nncam.NNCAM_EVENT_IMAGE:
            ctx.CameraCallback(nEvent)

    def CameraCallback(self, nEvent):
        if nEvent == nncam.NNCAM_EVENT_IMAGE:
            try:
                self.hcam.PullImageV4(self.buf, 0, 24, 0, None)
                self.total += 1
                print('pull image ok, total = {}'.format(self.total))
            except nncam.HRESULTException as ex:
                print('pull image failed, hr=0x{:x}'.format(ex.hr & 0xffffffff))
        else:
            print('event callback: {}'.format(nEvent))

    def run(self):
        while True:
            a = nncam.Nncam.EnumV2()
            if len(a) > 0:
                print('{}: flag = {:#x}, preview = {}, still = {}'.format(a[0].displayname, a[0].model.flag, a[0].model.preview, a[0].model.still))
                for r in a[0].model.res:
                    print('\t = [{} x {}]'.format(r.width, r.height))
                break
            else:
                print('no camera found')
                time.sleep(1)
        self.hcam = nncam.Nncam.Open(a[0].id)
        if self.hcam:
            try:
                width, height = self.hcam.get_Size()
                bufsize = nncam.TDIBWIDTHBYTES(width * 24) * height
                print('image size: {} x {}, bufsize = {}'.format(width, height, bufsize))
                self.buf = bytes(bufsize)
                if self.buf:
                    try:
                        self.hcam.StartPullModeWithCallback(self.cameraCallback, self)
                    except nncam.HRESULTException as ex:
                        print('failed to start camera, hr=0x{:x}'.format(ex.hr & 0xffffffff))
                input('press ENTER to exit')
            finally:
                self.hcam.Close()
                self.hcam = None
                self.buf = None
        else:
            print('failed to open camera')

if __name__ == '__main__':
    nncam.Nncam.GigeEnable(None, None)
    app = App()
    app.run()